package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import app.firezone.synk.network.Bgmi_Activity_One;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.LudoMatchDesignBinding;
import app.firezone.synk.network.model.Match_Model;

import java.util.ArrayList;

public class LudoMatchAdapter extends RecyclerView.Adapter<LudoMatchAdapter.Holder> {

    Context mContext;
    ArrayList<Match_Model> models;

    public LudoMatchAdapter(Context mContext, ArrayList<Match_Model> models) {
        this.mContext = mContext;
        this.models = models;
    }

    public void updateList(ArrayList<Match_Model> newList) {
        models.clear();
        models.addAll(newList);
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.ludo_match_design, parent, false);
        return new Holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull Holder holder, int position) {
        Match_Model match = models.get(position);

        holder.binding.dateTxt.setText(match.getDate());
        holder.binding.timeTxt.setText(match.getTime());
        holder.binding.prizepool.setText("₹" + match.getPrizepool() + ".00");
        holder.binding.entryFee.setText("₹" + match.getEntryfee());
        holder.binding.teamtype.setText(match.getTeamtype());
        holder.binding.matchName.setText(match.getMatchName() + " - Match " + match.getMatchno());
        holder.binding.matchMap.setText(match.getMap());

        Picasso.get()
                .load(match.getImages())
                .placeholder(R.drawable.loading_img)
                .error(R.drawable.loading_img)
                .into(holder.binding.matchImages);

        // Bind join status from model
        if (match.isUserJoined()) {
            holder.binding.btnText.setText("Joined");
            holder.binding.joinBtn.setCardBackgroundColor(ContextCompat.getColor(mContext, R.color.gray));
        } else if ("Ongoing".equalsIgnoreCase(match.getMatchstatus())) {
            holder.binding.btnText.setText("Started");
            holder.binding.joinBtn.setCardBackgroundColor(ContextCompat.getColor(mContext, R.color.gray));
        } else {
            holder.binding.btnText.setText("Join now");
        }

        // Show joined players count from model
        int joinedPlayers = match.getJoinedCount();
        int totalSeat = Integer.parseInt(match.getTotalPlayer());
        holder.binding.joinedProg.setProgress(joinedPlayers);
        holder.binding.joinedProg.setMax(totalSeat);
        holder.binding.totalJoinNum.setText(joinedPlayers + "/" + match.getTotalPlayer());

        if (joinedPlayers >= totalSeat) {
            holder.binding.btnText.setText("Full");
            holder.binding.totalJoin.setText("Match Full");
            holder.binding.joinBtn.setCardBackgroundColor(ContextCompat.getColor(mContext, R.color.gray));
        } else {
            int leftUsers = totalSeat - joinedPlayers;
            holder.binding.totalJoin.setText("Only " + leftUsers + " Slots Left.");
        }

        holder.itemView.setOnClickListener(view -> {
            Intent intent = new Intent(mContext, Bgmi_Activity_One.class);
            intent.putExtra("matchid", match.getId());
            intent.putExtra("gamename", match.getGamename());
            intent.putExtra("totalPlayer", match.getTotalPlayer());
            intent.putExtra("entryFee", match.getEntryfee());
            mContext.startActivity(intent);
        });
    }

    @Override
    public int getItemCount() {
        return models.size();
    }

    public static class Holder extends RecyclerView.ViewHolder {
        LudoMatchDesignBinding binding;

        public Holder(@NonNull View itemView) {
            super(itemView);
            binding = LudoMatchDesignBinding.bind(itemView);
        }
    }
}
